# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 6
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR6_strategy.txt
# LLM Suggested Fallback: C

def velvet_whisper(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    if current_round == 1:
        return "C"
    
    if current_round <= 3:
        return opp_history[-1]
    
    if current_round <= 7:
        if "return 'C'" in opponent_program_code and "random" not in opponent_program_code:
            if current_round % 2 == 0:
                return "D"
        if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
            return "D"
        return opp_history[-1]
    
    if current_round >= 8:
        if "return 'C'" in opponent_program_code and "if current_round == 10" in opponent_program_code:
            return "D"
        if opp_history.count("D") >= 5:
            return "D"
        return opp_history[-1]
    
    return "C"